// KontrolowanieGrupOkienDlg.cpp : implementation file
//

#include "stdafx.h"
#include "KontrolowanieGrupOkien.h"
#include "KontrolowanieGrupOkienDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CKontrolowanieGrupOkienDlg dialog




CKontrolowanieGrupOkienDlg::CKontrolowanieGrupOkienDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CKontrolowanieGrupOkienDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CKontrolowanieGrupOkienDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST3, list1);
	DDX_Control(pDX, IDC_SLIDER1, slider1);
	DDX_Control(pDX, IDC_SLIDER2, slider2);
	DDX_Control(pDX, IDC_SLIDER3, slider3);
	DDX_Control(pDX, IDC_SLIDER4, slider4);
	DDX_Control(pDX, IDC_EDIT2, edit1);
	DDX_Control(pDX, IDC_EDIT3, edit2);
	DDX_Control(pDX, IDC_EDIT4, edit3);
	DDX_Control(pDX, IDC_EDIT5, edit4);
	DDX_Control(pDX, IDC_COMBO1, combo1);
	DDX_Control(pDX, IDC_CHECK1, checkBox1);
}

BEGIN_MESSAGE_MAP(CKontrolowanieGrupOkienDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER1, &CKontrolowanieGrupOkienDlg::OnNMCustomdrawSlider1)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER2, &CKontrolowanieGrupOkienDlg::OnNMCustomdrawSlider2)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER3, &CKontrolowanieGrupOkienDlg::OnNMCustomdrawSlider3)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER4, &CKontrolowanieGrupOkienDlg::OnNMCustomdrawSlider4)
	ON_BN_CLICKED(IDC_BUTTON1, &CKontrolowanieGrupOkienDlg::OnBnClickedButton1)

END_MESSAGE_MAP()


// CKontrolowanieGrupOkienDlg message handlers

BOOL CKontrolowanieGrupOkienDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	RECT r;
	list1.GetWindowRect(&r);

	int szerListy = r.right - r.left;
	int szerKolumny = szerListy / 2;

	list1.InsertColumn(0,L"Tytu Okna",LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(1,L"Uchwyt Okna",LVCFMT_LEFT, szerKolumny, 0);

	int szerMonitora = ::GetSystemMetrics(SM_CXSCREEN);
	int wysMonitora = ::GetSystemMetrics(SM_CYSCREEN);
	slider1.SetRangeMax(szerMonitora);
	slider2.SetRangeMax(wysMonitora);
	slider3.SetRangeMax(szerMonitora);
	slider4.SetRangeMax(wysMonitora);

	checkBox1.SetCheck(TRUE);
	
	::EnumWindows((WNDENUMPROC)DodajWiersz,(LPARAM)&list1);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CKontrolowanieGrupOkienDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CKontrolowanieGrupOkienDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

int CALLBACK CKontrolowanieGrupOkienDlg::DodajWiersz(HWND uchwyt, LPARAM lParam)
{

	CListCtrl * list = (CListCtrl*)lParam;

	const int MAX_CHAR_SIZE=128;

	wchar_t tytul[MAX_CHAR_SIZE];
	::GetWindowText(uchwyt,tytul,MAX_CHAR_SIZE);

	if (::IsWindowVisible(uchwyt))
	{
		int row = list->GetHeaderCtrl()->GetItemCount() - 1;
		int index = list->InsertItem(row, tytul);
		CString sUchwyt;
		sUchwyt.AppendFormat(L"%d",(int)uchwyt);
		list->SetItem(index, 1, LVIF_TEXT, sUchwyt, 0, 0, 0, NULL);
	}

	return 1;
}


void CKontrolowanieGrupOkienDlg::OnNMCustomdrawSlider1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	CString wartosc;
	wartosc.AppendFormat(L"%d",slider1.GetPos());
	edit1.SetWindowTextW(wartosc);
}

void CKontrolowanieGrupOkienDlg::OnNMCustomdrawSlider2(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	CString wartosc;
	wartosc.AppendFormat(L"%d",slider2.GetPos());
	edit2.SetWindowTextW(wartosc);
}

void CKontrolowanieGrupOkienDlg::OnNMCustomdrawSlider3(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	CString wartosc;
	wartosc.AppendFormat(L"%d",slider3.GetPos());
	edit3.SetWindowTextW(wartosc);
}

void CKontrolowanieGrupOkienDlg::OnNMCustomdrawSlider4(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	CString wartosc;
	wartosc.AppendFormat(L"%d",slider4.GetPos());
	edit4.SetWindowTextW(wartosc);

}

void PrzesunOkna(HWND * okna, int ileOkien, HWND pozycjaOkna, int flagi, int x, int y, int szer, int wys)
{
	HDWP s = BeginDeferWindowPos(ileOkien);
	for(int i=0;i<ileOkien;i++)
	{
		s = DeferWindowPos(s,okna[i],pozycjaOkna,x,y,szer,wys,flagi);
	}
	EndDeferWindowPos(s);
}

void CKontrolowanieGrupOkienDlg::OnBnClickedButton1()
{
	if(list1.GetSelectedCount() == 0)
		return;

	HWND * hwndTab = new HWND[list1.GetSelectedCount()];
	int j=0;
	for(int i=0;i<list1.GetItemCount();i++)
	{
		if(list1.GetItemState(i,LVIS_SELECTED) & LVIS_SELECTED)
		{
			CString hwndText = list1.GetItemText(i, 1);
			hwndTab[j++] = (HWND)_wtoi(hwndText);
		}
	}
	int flagi = (checkBox1.GetCheck() == TRUE)?SWP_SHOWWINDOW:SWP_HIDEWINDOW;
	HWND pozycjaOkna;
	int hh = combo1.GetCurSel();
	switch(combo1.GetCurSel())
	{
		case 0: pozycjaOkna = HWND_BOTTOM; break;
		case 1: pozycjaOkna = HWND_NOTOPMOST; break;
		case 2: pozycjaOkna = HWND_TOP; break;
		case 3: pozycjaOkna = HWND_TOPMOST; break;
		default: pozycjaOkna = HWND_TOPMOST; break;
	}
	PrzesunOkna(hwndTab,list1.GetSelectedCount(),pozycjaOkna,flagi,slider1.GetPos(),slider2.GetPos(),slider3.GetPos(),slider4.GetPos());
	delete [] hwndTab;
	hwndTab = NULL;
}
